% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Population_getters.R
\name{getAddCoefs}
\alias{getAddCoefs}
\title{Get additive coefficients.}
\usage{
getAddCoefs(pop)
}
\arguments{
\item{pop}{a \code{Population} object with additive effects
attached}
}
\value{
\code{getAddCoefs} returns the additive coefficients
  currently in use by the population.
}
\description{
Retrieve additive coefficients from population.
}
\details{
\code{getAddCoefs} retrieves the additive coefficients currently
in use in a \code{Population} object, assuming additive effects
have been attached.
}
\examples{
# Construct a population with additive effects
pop <- Population(
  popSize = 200, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100),
  broadH2 = 0.6, narrowh2 = 0.6, traitVar = 40
)
pop <- addEffects(pop)

# Get additive coefficients
additive <- getAddCoefs(pop)
}
\seealso{
\code{\link{addEffects}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
