% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{plot_coverage}
\alias{plot_coverage}
\title{Plot coverage probability of posterior credible intervals}
\usage{
plot_coverage(
  object,
  type,
  newdata = NULL,
  groups = NULL,
  levels = c(50, 95),
  period = NULL,
  by_group = FALSE,
  by_unseen = FALSE
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{type}{A string specifying the name of the observations to plot. This should match one
of the names of the response variables in the \code{obs} argument used int the call to \code{\link{epim}}.}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful for forecasting}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{levels}{A numeric vector defining the levels of the plotted
credible intervals.}

\item{period}{Buckets computed empirical probabilities into time periods
if specified.}

\item{by_group}{Plot coverage for each group individually}

\item{by_unseen}{Plot coverage separately for seen and unseen observations.
Observations are 'seen' if they were used for fitting.}
}
\value{
A \code{ggplot} object.
}
\description{
Plots histograms showing empirical coverage of credible intervals
specified using 'levels'. Can bucket by time period, by group, by
whether the observation is new (not used in fitting).
}
