% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epidatacall.R
\name{fetch_args_list}
\alias{fetch_args_list}
\alias{fetch_args}
\title{Set custom API request parameters}
\usage{
fetch_args_list(
  ...,
  fields = NULL,
  disable_date_parsing = FALSE,
  disable_data_frame_parsing = FALSE,
  return_empty = FALSE,
  timeout_seconds = 15 * 60,
  base_url = NULL,
  dry_run = FALSE,
  debug = FALSE,
  format_type = c("json", "classic", "csv")
)
}
\arguments{
\item{...}{not used for values, forces later arguments to bind by name}

\item{fields}{a list of epidata fields to return, or \code{NULL} to return all
fields (default). e.g. \code{c("time_value", "value")} to return only the
\code{time_value} and \code{value} fields or \code{c("-direction")} to return everything
except the direction field}

\item{disable_date_parsing}{disable automatic date parsing}

\item{disable_data_frame_parsing}{disable automatic conversion to data frame;
this is only supported by endpoints that only support the 'classic' format
(non-tabular)}

\item{return_empty}{boolean that allows returning an empty tibble if there is
no data}

\item{timeout_seconds}{the maximum amount of time (in seconds) to wait for a
response from the API server}

\item{base_url}{base URL to use; by default \code{NULL}, which means the global
base URL \code{"https://api.delphi.cmu.edu/epidata/"}}

\item{dry_run}{if \code{TRUE}, skip the call to the API and instead return the
\code{epidata_call} object (useful for debugging)}

\item{debug}{if \code{TRUE}, return the raw response from the API}

\item{format_type}{the format to request from the API, one of classic, json,
csv; this is only used by \code{fetch_debug}, and by default is \code{"json"}}
}
\value{
A \code{fetch_args} object containing all the specified options
}
\description{
Used to specify custom options when making API requests, such as to set
timeouts or change data formats. These options are used by \code{fetch()} when it
makes calls to the Epidata API.
}
