% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_quidel}
\alias{pvt_quidel}
\title{Quidel COVID-19 and influenza testing data}
\usage{
pvt_quidel(auth, locations, epiweeks, fetch_args = fetch_args_list())
}
\arguments{
\item{auth}{string. Restricted access key (not the same as API key).}

\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/quidel.html}

Data provided by Quidel Corp., which contains flu lab test results.
}
\examples{
\dontrun{
pvt_quidel(
  auth = Sys.getenv("SECRET_API_AUTH_QUIDEL"),
  epiweeks = epirange(201201, 202001),
  locations = "hhs1"
)
}
}
\keyword{endpoint}
