## ----init, include=F----------------------------------------------------------
library(knitr)
opts_chunk$set(message=FALSE, warning=FALSE, eval=TRUE, echo=TRUE)

## -----------------------------------------------------------------------------
library(outbreaks)
library(epicontacts)

str(ebola_sim)


## -----------------------------------------------------------------------------
x <- make_epicontacts(linelist = ebola_sim$linelist, contacts = ebola_sim$contacts, directed = TRUE)

## -----------------------------------------------------------------------------
class(x)

## -----------------------------------------------------------------------------
is.list(x)

## -----------------------------------------------------------------------------
head(x$linelist)

## -----------------------------------------------------------------------------
head(x$contacts)

## -----------------------------------------------------------------------------
x

## -----------------------------------------------------------------------------
summary(x)

## -----------------------------------------------------------------------------
rokupafuneral <- subset(x, 
                        node_attribute = list("hospital" = "Rokupa Hospital"), 
                        edge_attribute = list("source" = "funeral"))

## -----------------------------------------------------------------------------
summary(rokupafuneral)

## ---- eval = F----------------------------------------------------------------
#  plot(rokupafuneral, y = "outcome")

