% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amr_read_taxonomy.R
\name{amr_read_taxonomy}
\alias{amr_read_taxonomy}
\title{assign taxonomy for phylogenetic and AMR for each read}
\arguments{
\item{path.to.wimp.files}{path to folder containing raw CSV files from WIMP analysis}

\item{path.to.amr.files}{path to folder containing raw CSV files from ARMA analysis}

\item{coveragenumber}{Minimum percentage of a gene that must be
covered. Range from 0 to 99, default = 80}
}
\value{
data.frame with double classified reads
}
\description{
Given raw data for AMR and WIMP, provides full AMR and
taxon info for those reads that assign to both
}
\examples{
\dontrun{
amr_read_taxonomy(path.to.wimp.files = "path/to/wimp_files",
path.to.amr.files = "path/to/amr_files", coveragenumber = 80)
}
}
