% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{gsea_gson}
\alias{gsea_gson}
\title{gsea_gson}
\usage{
gsea_gson(
  geneList,
  gson,
  nPerm = 1000,
  exponent = 1,
  minGSSize = 10,
  maxGSSize = 500,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  method = "multilevel",
  adaptive = FALSE,
  minPerm = 101,
  maxPerm = 1e+05,
  pvalThreshold = 0.1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{geneList}{A named numeric vector of gene statistics (e.g., log fold change), ranked in descending order.}

\item{gson}{A GSON object containing gene set information.}

\item{nPerm}{Number of permutations for p-value calculation (default: 1000).}

\item{exponent}{Weighting exponent for enrichment score (default: 1.0).}

\item{minGSSize}{minimal size of each geneSet for analyzing}

\item{maxGSSize}{maximal size of each geneSet for analyzing}

\item{pvalueCutoff}{P-value cutoff.}

\item{pAdjustMethod}{P-value adjustment method (e.g., "BH").}

\item{method}{Permutation method.}

\item{adaptive}{Logical. Use adaptive permutation.}

\item{minPerm}{Minimum permutations for adaptive mode.}

\item{maxPerm}{Maximum permutations for adaptive mode.}

\item{pvalThreshold}{P-value threshold for early stopping.}

\item{verbose}{Logical. Print progress messages.}

\item{...}{Additional parameters passed to gsea()}
}
\value{
gseaResult object
}
\description{
generic function for gene set enrichment analysis
}
\author{
Guangchuang Yu
}
