% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotExtent.r
\name{plotExtent}
\alias{plotExtent}
\title{Create spatial polygon same size as a plot}
\usage{
plotExtent(x = NULL)
}
\arguments{
\item{x}{Either \code{NULL} (default), an object of class \code{crs}, a coordinate reference string (PROJ6 WKT string), or an object with a coordinate reference system. If any of these is provided, the \code{SpatVector} object will have this CRS.}
}
\value{
\code{SpatVector}
}
\description{
This function creates a "rectangular" \code{SpatVector} object with the same dimensions as a plot window. It is especially useful for cropping subsequent rasters or vector objects to the plot window. A plot must be made before calling this function.
}
\examples{

if (FALSE) {

library(sf)

data(mad0)
plot(st_geometry(mad0))
outline <- plotExtent(mad0)
plot(outline, col='cornflowerblue', lty='dotted')
plot(st_geometry(mad0), add=TRUE)

}

}
\seealso{
\link{extentToVect}
}
