% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madClim2070.r
\docType{data}
\name{madClim2070}
\alias{madClim2070}
\title{Future climate rasters for Madagascar}
\format{
An object of class \code{'SpatRaster'}.
}
\source{
\href{https://worldclim.org}{WorldClim}
}
\description{
Rasters representing average climate across 2061-2080 modeled with CanESM5 for SSP 585 for Madagascar from WorldClim version 2.1. Values of these rasters have been rounded to one digit, so \emph{please do not use these for "official" work}. Please also note that CanESM5 in CMIP6 is known to run "too hot", but is useful here to aid illustration.
}
\examples{

library(terra)
rastFile <- system.file('extdata', 'madClim2070.tif', package='enmSdmX')
madClimFut <- rast(rastFile)
plot(madClimFut)

}
\keyword{Madagascar}
\keyword{climate}
