% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enerscape.R
\name{enerscape}
\alias{enerscape}
\title{Compute Energy Landscapes}
\usage{
enerscape(dem, m, unit = "joule", neigh = 8)
}
\arguments{
\item{dem}{raster file of the digital elevation model, either a raster or a
full path location of the file.}

\item{m}{species body mass (kg).}

\item{unit}{if joules ('joule') or kilocalories ('kcal').}

\item{neigh}{number of neighbor cells that are connected together.}
}
\value{
A list with elements a rasterStack of the digital elevation model,
  slope, energy landscape, and conductance and the conductance as a transitionLayer for
  path analysis.
}
\description{
This is the main function to compute energy landscapes from a digital
elevation model and body mass of animals based on the model from Pontzer
(2016). The core of the computations are done using the \emph{gdistance}
(Etten, 2017) package.
}
\details{
From the digital elevation model, transition slopes, energy costs
  and conductances (1 / work) are computed based on the model described in
  Pontzer (2016).
}
\examples{
library(terra)
library(enerscape)

data("volcano")
dem <- rast(volcano)
en <- enerscape(dem, 10, unit = "kcal", neigh = 16)
}
\references{
Pontzer, H. (2016). A unified theory for the energy cost of legged
  locomotion. Biology Letters, 12(2), 20150935. \doi{
  https://doi.org/10.1098/rsbl.2015.0935}.
}
