% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/en_path.R
\name{en_path}
\alias{en_path}
\title{Compute the energy costs for a chosen path}
\usage{
en_path(en, p = NULL, draw = FALSE, n = NULL, plot = TRUE)
}
\arguments{
\item{en}{an enerscape object.}

\item{p}{path as SpatialLines.}

\item{draw}{if TRUE the path will be chosen by drawing it on the map/}

\item{n}{number of node points for the path.}

\item{plot}{if TRUE plot the path}
}
\value{
A list with elements the path, its travel distance and energy costs.
}
\description{
This returns the distance and energy costs of traveling a chosen path.
Optionally, the path can be selected by specifying the number of nodes and
clicking on the plot.
}
\examples{
\dontrun{
library(raster)
data("volcano")
dem <- raster(volcano)
en <- enerscape(dem, 10, unit = "kcal", neigh = 16)
en_path(en, draw = TRUE, n = 10)
}
}
\references{
Etten, J. van. (2017). R Package gdistance: Distances and Routes
  on Geographical Grids. Journal of Statistical Software, 76(1), 1–21.
  \doi{https://doi.org/10.18637/jss.v076.i13}.

  Pontzer, H. (2016). A unified theory for the energy cost of legged
  locomotion. Biology Letters, 12(2), 20150935. \doi{
  https://doi.org/10.1098/rsbl.2015.0935}.

  di Prampero, P. E., Cortili, G., Mognoni, P., & Saibene, F. (1979).
  Equation of motion of a cyclist. Journal of Applied Physiology, 47(1),
  201–206. \doi{https://doi.org/10.1152/jappl.1979.47.1.201}
}
