% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pln_probit.R
\name{pln_probit}
\alias{pln_probit}
\title{Recursive PLN-Probit Model}
\usage{
pln_probit(
  form_pln,
  form_probit,
  data = NULL,
  par = NULL,
  method = "BFGS",
  init = c("zero", "unif", "norm", "default")[4],
  H = 20,
  verbose = 0,
  accu = 10000
)
}
\arguments{
\item{form_pln}{Formula for the first-stage Poisson lognormal model}

\item{form_probit}{Formula for the second-stage probit model}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm. Without gradient, NM is much faster than BFGS}

\item{init}{Initialization method}

\item{H}{Number of quadrature points}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}
}
\value{
A list containing the results of the estimated model
}
\description{
Estimate a Poisson Lognormal model (first-stage) and a probit model (second-stage) whose error terms are bivariate normally distributed. This model still works if the first-stage dependent variable is not a regressor in the second stage.
}
\examples{
library(MASS)
N = 1000
rho = -0.5
set.seed(1)

x = rbinom(N, 1, 0.5)
z = rnorm(N)

e = mvrnorm(N, mu=c(0,0), Sigma=matrix(c(1,rho,rho,1), nrow=2))
e1 = e[,1]
e2 = e[,2]

y1 = rpois(N, exp(-1 + x + z + e1))
y2 = as.numeric(1 + x + z + log(1+y1) + e2 > 0)
est = pln_probit(y1~x+z, y2~x+z+log(1+y1))
est$estimates
}
\references{
Peng, Jing. (2022) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research (Forthcoming), Available at SSRN: https://ssrn.com/abstract=3494856
}
\seealso{
Other endogeneity: 
\code{\link{bilinear}()},
\code{\link{biprobit_latent}()},
\code{\link{biprobit_partial}()},
\code{\link{biprobit}()},
\code{\link{pln_linear}()},
\code{\link{probit_linear_latent}()},
\code{\link{probit_linear_partial}()},
\code{\link{probit_linear}()}
}
\concept{endogeneity}
