% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eml_version.R
\name{guess_schema_location}
\alias{guess_schema_location}
\title{Guess an appropriate \code{schemaLocation} value for a given version of the schema}
\usage{
guess_schema_location(version = eml_version())
}
\arguments{
\item{version}{Optional. Override the version of the schema. Defaults to the
current version returned by \code{eml_version}. See \code{eml_version} for information
on how to change the current version.}
}
\value{
Returns a string suitable as a value for \code{schemaLocation} or \code{NULL}
if a value wasn't found.
}
\description{
This is a simple helper to make filling in the \code{schemaLocation} attribute
on documents this package creates. Supports EML 2.1.1 and newer.
}
\examples{
\dontrun{
# Get an appropriate schemaLocation value for the current version fo EML
guess_schema_location()

# Get an appropriate value for EML 2.1.1
guess_schema_location("eml-2.1.1")
}
}
