% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.r
\name{notify_once}
\alias{notify_once}
\alias{reset_notification}
\title{Print a warning message if not printed earlier}
\usage{
notify_once(id, ..., fun = log_message)

reset_notification(id, if_top_level = TRUE)
}
\arguments{
\item{id}{Warning message id. This is used internally to refer to the
message.}

\item{...}{Sent to \code{\link{warning}}.}

\item{fun}{Function to display the notification with. Typical choices are
\code{\link{message}} or \code{\link{warning}}.}

\item{if_top_level}{If \code{TRUE} the notifications will only be reset if
\code{reset_notification} was called from a top-level function call.
This behaviour prevents the notifications from being reset multiple times
during nested calls to functions such as \code{\link{fit}} and
\code{\link{evaluate}}.}
}
\description{
To avoid flooding the user with identical warning messages, this function
keeps track of which have already been shown.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

