% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{map_plot}
\alias{map_plot}
\title{Visualises regional disaggregrated estimates on a map}
\usage{
map_plot(object, indicator = "all", MSE = FALSE, CV = FALSE,
  map_obj = NULL, map_dom_id = NULL, map_tab = NULL, col = c("green",
  "yellow", "red"))
}
\arguments{
\item{object}{an object of type emdi, containing the estimates to be 
visualised.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean" "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", "Poverty_Gap", "Gini", 
"Quintile_Share" or the function name/s of "custom_indicator/s"; 
(ii) groups of indicators: "Quantiles", "Poverty" or 
"Inequality". Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (\code{link{ebp}}) and do not 
appear in groups of indicators even though these might belong to one of the 
groups.}

\item{MSE}{optional logical. If TRUE, the MSE is also visualised.}

\item{CV}{optional logical. If TRUE, the CV is also visualised.}

\item{map_obj}{an \code{SpatialPolygonsDataFrame} object as defined by the
\code{sp} package on which the data should be visualised.}

\item{map_dom_id}{a character string containing the name of a variable in
\code{map_obj} that indicates the domains.}

\item{map_tab}{a \code{data.frame} object with two columns that match the 
domain variable from the census data set (first column) with the domain 
variable in the map_obj (second column). This should only be used if the IDs 
in both objects differ.}

\item{col}{A \code{vector} of length 3 defining the lowest, mid and highest color in the plots}
}
\value{
creates the plots demanded
}
\description{
Function \code{map_plot} creates spatial visualisations of the estimates
obtained by small area estimation methods or direct estimation.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_pop")

# generate emdi object with additional indicators; here via function ebp()
set.seed(100); emdi_model <- ebp( fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
pov_line = 10722.66, transformation = "box.cox", L= 1, MSE = TRUE, B = 1,
custom_indicator = list( my_max = function(y, pov_line){max(y)},
my_min = function(y, pov_line){min(y)}), na.rm = TRUE, cpus = 1)

# Load shape file
load(system.file("shapes/shape_austria_dis.RData", package="emdi"))

# Create mapping table such that variables that indicate domains correspond
# in population data and shape file
mapping_table <- data.frame(unique(eusilcA_pop$district), 
unique(shape_austria_dis$NAME_2))

# when rgeos is not available, polygon geometry 	computations in 
# maptools depends on the package gpclib,
# which has a restricted licence. It is disabled by default; 
# to enable gpclib, type gpclibPermit()
gpclibPermit() 
# Create map plot for mean indicator - point and MSE estimates but no CV
map_plot(object = emdi_model, MSE = TRUE, CV = FALSE, 
map_obj = shape_austria_dis, indicator = c("Mean"), map_dom_id = "NAME_2", 
map_tab = mapping_table)
}
}
\seealso{
\code{\link{ebp}}, \code{\link{emdiObject}},
\code{\link[maptools]{readShapePoly}}
}

