% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resultNest_5p_Dallwitz.R
\docType{data}
\encoding{UTF-8}
\name{resultNest_5p_Dallwitz}
\alias{resultNest_5p_Dallwitz}
\title{Fit using the nest database}
\format{A list with fitted information about data(nest)}
\usage{
resultNest_5p_Dallwitz
}
\description{
Fit using the nest database
}
\details{
Result of the fit using the nest database
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
x <- structure(c(4.91191231405918, 12.7453211281394, 31.2670410811077, 
 5.7449376569153, -0.825689964543813), .Names = c("Dallwitz_b1",
 "Dallwitz_b2", "Dallwitz_b3", "Dallwitz_b4", "Dallwitz_b5"))
pfixed <- c(rK=1.208968)
resultNest_5p_Dallwitz <- searchR(parameters=x, fixed.parameters=pfixed, 
	temperatures=formated, derivate=dydt.Gompertz, M0=0.3470893, 
	test=c(Mean=39.33, SD=1.92))
plotR(result=resultNest_5p_Dallwitz, show.hist = TRUE,
             ylim=c(0, 8), curves="ML quantiles")
}
}
\references{
Girondot, M., Monsinjon, J., Guillon, J.-M., Submitted. 
            Delimitation of the embryonic thermosensitive period for 
            sex determination using an embryo growth model reveals a 
            potential bias for sex ratio prediction in turtles.
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\keyword{datasets}
