% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize_xgb.R
\name{step_discretize_xgb}
\alias{step_discretize_xgb}
\alias{tidy.step_discretize_xgb}
\title{Discretize numeric variables with XgBoost}
\usage{
step_discretize_xgb(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  outcome = NULL,
  sample_val = 0.2,
  learn_rate = 0.3,
  num_breaks = 10,
  tree_depth = 1,
  min_n = 5,
  rules = NULL,
  skip = FALSE,
  id = rand_id("discretize_xgb")
)

\method{tidy}{step_discretize_xgb}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Defaults to \code{"predictor"}.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is used as the
outcome to train XgBoost models in order to discretize explanatory
variables.}

\item{sample_val}{Share of data used for validation (with early stopping) of the learned splits
(the rest is used for training). Defaults to 0.20.}

\item{learn_rate}{The rate at which the boosting algorithm adapts from
iteration-to-iteration. Corresponds to \code{eta} in the \pkg{xgboost} package.
Defaults to 0.3.}

\item{num_breaks}{The \emph{maximum} number of discrete bins to bucket continuous
features. Corresponds to \code{max_bin} in the \pkg{xgboost} package. Defaults to
10.}

\item{tree_depth}{The maximum depth of the tree (i.e. number of splits).
Corresponds to \code{max_depth} in the \pkg{xgboost} package. Defaults to 1.}

\item{min_n}{The minimum number of instances needed to be in each node.
Corresponds to \code{min_child_weight} in the \pkg{xgboost} package. Defaults to 5.}

\item{rules}{The splitting rules of the best XgBoost tree to retain for
each variable.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_discretize_xgb} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).
}
\description{
\code{step_discretize_xgb} creates a \emph{specification} of a recipe step that will
discretize numeric data (e.g. integers or doubles) into bins in a
supervised way using an XgBoost model.
}
\details{
\code{step_discretize_xgb()} creates non-uniform bins from numerical
variables by utilizing the information about the outcome variable and
applying the xgboost model. It is advised to impute missing values before
this step. This step is intended to be used particularly with linear models
because thanks to creating non-uniform bins it becomes easier to learn
non-linear patterns from the data.

The best selection of buckets for each variable is selected using
an internal early stopping scheme implemented in the \pkg{xgboost}
package, which makes this discretization method prone to overfitting.

The pre-defined values of the underlying xgboost learns good
and reasonably complex results. However, if one wishes to tune them the
recommended path would be to first start with changing the value of
\code{num_breaks} to e.g.: 20 or 30. If that doesn't give satisfactory results
one could experiment with modifying the \code{tree_depth} or \code{min_n} parameters.
Note that it is not recommended to tune \code{learn_rate} simultaneously with
other parameters.

This step requires the \pkg{xgboost} package. If not installed, the
step will stop with a note about installing the package.

Note that the original data will be replaced with the new bins.
}
\examples{
library(modeldata)
data(credit_data)
library(rsample)
library(recipes)

split <- initial_split(credit_data, strata = "Status")

credit_data_tr <- training(split)
credit_data_te <- testing(split)

xgb_rec <- 
  recipe(Status ~ ., data = credit_data_tr) \%>\%
  step_medianimpute(all_numeric()) \%>\%
  step_discretize_xgb(all_numeric(), outcome = "Status")

if (rlang::is_installed("xgboost")) {
  xgb_rec <- prep(xgb_rec, training = credit_data_tr)

   bake(xgb_rec, credit_data_te, Price)
}
}
\seealso{
\code{\link[=step_discretize_cart]{step_discretize_cart()}}, \code{\link[recipes:recipe]{recipes::recipe()}},
\code{\link[recipes:prep]{recipes::prep.recipe()}}, \code{\link[recipes:bake]{recipes::bake.recipe()}}
}
\concept{discretization}
\concept{factors}
\concept{preprocessing}
\concept{xgboost}
\keyword{binning}
