% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{html}
\alias{html}
\title{Add an HTML body to a message object.}
\usage{
html(
  msg,
  content,
  disposition = "inline",
  charset = "utf-8",
  encoding = "quoted-printable"
)
}
\arguments{
\item{msg}{A message object.}

\item{content}{A string of message content or the path to a file containing HTML.}

\item{disposition}{How content is presented (Content-Disposition).}

\item{charset}{How content is encoded.}

\item{encoding}{How content is transformed to ASCII (Content-Transfer-Encoding).}
}
\value{
A message object.
}
\description{
Add an HTML body to a message object.
}
\examples{
library(magrittr)

# Inline HTML message.
msg <- envelope() \%>\% html("<b>Hello!</b>")

# Read HTML message from a file.
msg <- envelope() \%>\% html("message.html")
}
\seealso{
\code{\link{text}}
}
