% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address.R
\name{compliant}
\alias{compliant}
\title{Tests whether an email address is syntactically correct}
\usage{
compliant(addr)
}
\arguments{
\item{addr}{An email address.}
}
\value{
A Boolean.
}
\description{
Checks whether an email address conforms to the \href{https://en.wikipedia.org/wiki/Email_address#Syntax}{syntax rules}.
}
\details{
An email address may take either of the following forms:
\itemize{
\item \code{local@domain} or
\item \verb{Display Name <local@domain>}.
}
}
\examples{
compliant("alice@example.com")
compliant("alice?example.com")
}
