% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_msdf.R
\name{msdf}
\alias{msdf}
\alias{new_msdf}
\alias{is.msdf}
\title{Create and test for a multiple scaled data frame}
\usage{
new_msdf(x = list(), method, mrit_min, negative_too, sclvals = NULL, df)

is.msdf(x)
}
\arguments{
\item{x}{either a multiple scaled data frame (\code{new_msdf()}) or an
arbitrary object to test (\code{is_msdf()}).}

\item{method}{the method used to produce the multiple scaled data frame
(either \code{disjoint()} or \code{overlap()}).}

\item{mrit_min}{a numeric constant of length one to specify the marginal
corrected item-total correlation. Its value is in the range of 0-1.}

\item{negative_too}{a logical constant indicating whether reversed items are
included in the analysis. The default is set to \code{FALSE}.}

\item{sclvals}{a numeric vector of length two indicating the start- and
endpoint of a scale.}

\item{df}{the data frame to analyze.}
}
\value{
\code{new_msdf()} returns a list of data frames with a few
  attributes that partially summarize the scaling process.

\code{is.msdf()} returns a logical vector of length one. \code{TRUE}
  indicates that the object is of type \code{msdf}.
}
\description{
\code{new_msdf()} creates a multiple scaled data frame
  (\code{msdf}).

\code{is.msdf()} tests if an object is a multiple scaled data
  frame.
}
\details{
Objects of type `msdf` are for internal use only.
}
