% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{valid_connection}
\alias{valid_connection}
\title{Validate healthy Elasticsearch connection.}
\usage{
valid_connection(url)
}
\arguments{
\item{url}{The URL to validate.}
}
\value{
Boolean
}
\description{
Validates healthy Elasticsearch connections by attempting to call the cluster healthcheck
endpoint. In doing to, it defends against incorrect URLs to Elasticsearch clusters. Requires
that URLs point directly to a master node - i.e. the endpoint that would return the default
Elasticsearch message, "You Know, for Search", e.g. `http://localhost:9200`.
}
\examples{
\dontrun{
url <- "http://localhost:9200"
valid_connection(url)
# TRUE

url <- "http://localhost:9201"
valid_connection(url)
#  Error: Failed to connect to localhost port 9201: Connection refused
}
}
