% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_optimal_t.R
\name{find_optimal_t}
\alias{find_optimal_t}
\title{Optimal alignment to a smooth curve}
\usage{
find_optimal_t(srv_curve, s, q, initial_t = s, eps = 10 * .Machine$double.eps)
}
\arguments{
\item{srv_curve}{srv transformation of the smooth curve, needs to be vectorised}

\item{s}{time points for q, first has to be 0, last has to be 1}

\item{q}{square root velocity vectors, one less than time points in s}

\item{initial_t}{starting value for the optimisation algorithm}

\item{eps}{convergence tolerance}
}
\value{
optimal time points for q, without first value 0 and last value 1,
optimal time points have the distance of the observation to the srv_curve as an attribute
}
\description{
Finds optimal alignment for a discrete open srv curve to a smooth curve
}
