% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pch.R
\name{Pch}
\alias{Pch}
\alias{ppch}
\alias{pch}
\alias{dpch}
\alias{hpch}
\alias{Hpch}
\alias{qpch}
\alias{rpch}
\title{The Piecewise Constant Hazards distribution.}
\usage{
ppch(q, cuts, levels, lower.tail = TRUE, log.p = FALSE)
dpch(x, cuts, levels, log = FALSE)
hpch(x, cuts, levels, log = FALSE)
Hpch(x, cuts, levels, log.p = FALSE)
qpch(p, cuts, levels, lower.tail = TRUE, log.p = FALSE)
rpch(n, cuts, levels)
}
\arguments{
\item{cuts}{Vector of cut points defining the intervals where the hazard function
is constant.}

\item{levels}{Vector of levels (values of the hazard function).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \le x)}{P(X <= x)}, otherwise, \eqn{P(X > x)}{P(X > x)}.}

\item{x, q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken 
to be the number required.}
}
\value{
\code{dpch} gives the density, 
\code{ppch} gives the distribution function, 
\code{qpch} gives the quantile function, 
\code{hpch} gives the hazard function, 
\code{Hpch} gives the cumulative hazard function, and
\code{rpch} generates random deviates.
}
\description{
Density, distribution function, quantile function, hazard function,
cumulative hazard function, and random generation for the Piecewice
Constant Hazards (pch) distribution.
}
\details{
The pch distribution has a hazard function that is piecewise constant
on intervals defined by cutpoints 
\deqn{0 < c_1 < \cdots < c_n < \infty, n \ge 0}{0 < c_1 < ... < c_n < \infty, n \ge 0}.
If \code{n = 0}, this reduces to an exponential distribution.
}
\note{
the parameter \code{levels} must have length at least 2, and the 
number of cut points must be one less than the number of levels. q
}
\keyword{distribution}
