% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsize.R
\name{effectsize}
\alias{effectsize}
\title{Effect Size}
\usage{
effectsize(model, ...)
}
\arguments{
\item{model}{Statistical model or object of class \code{htest}.}

\item{...}{Arguments passed to or from other methods. See \code{eta_squared}, \code{standardize_parameters}, \code{cramers_v} or \code{t_to_d}.}
}
\description{
See the documentation for \code{\link{eta_squared}}, \code{\link{standardize_parameters}}, \code{\link{cramers_v}}.
}
\examples{
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))
Xsq <- chisq.test(contingency_table)
effectsize(Xsq)

Ts <- t.test(1:10, y = c(7:20))
effectsize(Ts)

fit <- lm(mpg ~ factor(cyl) * wt + hp, data = mtcars)
effectsize(fit)

anova_table <- anova(fit)
effectsize(anova_table)

}
