% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{estimateEffect}
\alias{estimateEffect}
\title{Estimate the total causal effect}
\usage{
estimateEffect(data, x, y, amat, bootstrap = FALSE)
}
\arguments{
\item{data}{a data frame consisting of iid observational data}

\item{x}{(integer) positions of treatment variables in the adjacency matrix;
can be a singleton (single treatment) or a vector (multiple treatments)}

\item{y}{(integer) position of the outcome variable in the adjacency matrix}

\item{amat}{adjacency matrix representing a DAG, CPDAG or MPDAG}

\item{bootstrap}{If \code{TRUE}, will estimate the standard error covariance with
bootstrap (default: \code{FALSE})}
}
\value{
A vector of the same length as \code{x}. If \code{bootstrap=TRUE},
return a list of \code{(effect, se.cov)}.
}
\description{
Estimate the total causal effect of x on y with iterated least squares.
The resulting estimate has the minimal asymptotic covariance among all least
squares estimators.
}
\details{
Adjacency matrix \code{amat} represents the graphical information of the
underlying causal DAG (directed acyclic graph). The causal DAG should be
contained by the graph represented by \code{amat}, which can be a DAG, CPDAG
(essential graph), or more generally, an MPDAG (maximally oriented partially
directed acyclic graph).

Matrix \code{amat} is coded with the convention of \code{\link[pcalg]{amatType}}:
\itemize{
\item \code{amat[i,j]=0} and \code{amat[j,i]=1} means \code{i->j}
\item \code{amat[i,j]=1} and \code{amat[j,i]=0} means \code{i<-j}
\item \code{amat[i,j]=1} and \code{amat[j,i]=1} means \code{i--j}
\item \code{amat[i,j]=0} and \code{amat[j,i]=0} means \code{i  j}
}

\code{amat} can be learned from observational data with a structure learning
algorithm; see \code{\link[pcalg]{pc}}, \code{\link[pcalg]{ges}}
and \code{\link[pcalg]{LINGAM}}. Additional background knowledge can also be
incorporated with \code{\link[pcalg]{addBgKnowledge}}.
}
\examples{
data("ex1")
result <- estimateEffect(ex1$data, c(5,3), 7, ex1$amat.cpdag, bootstrap=TRUE)
print(result$effect)
print(result$effect - 1.96 * sqrt(diag(result$se.cov)))
print(result$effect + 1.96 * sqrt(diag(result$se.cov)))
# compare with truth
print(ex1$true.effects)

\dontrun{
# throws an error because the effect is not identified
estimateEffect(ex1$data, 3, 7, ex1$amat.cpdag)
}
}
\seealso{
\code{\link{isIdentified}} is called for determining if an effect can be
identified. See also \code{\link[pcalg]{adjustment}}, \code{\link[pcalg]{ida}},
and \code{\link[pcalg]{jointIda}} for other estimators.
}
