% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_extract}
\alias{eem_extract}
\title{Extract EEM samples}
\usage{
eem_extract(eem, sample, remove = FALSE)
}
\arguments{
\item{eem}{Either an object of class \code{eem} or \code{eemlist}.}

\item{sample}{Either numeric of character vector. See \code{details} for more
information.}

\item{remove}{logical. Should EEMs removed (TRUE) or extracted (FALSE).}
}
\value{
Either an object of class \code{eem} or \code{eemlist}.
}
\description{
Extract EEM samples
}
\details{
\code{sample} argument can be either numeric or character vector. If
  it is numeric, samples at specified index will be removed.

  If \code{sample} is character, regular expression will be used and all
  sample names that have a partial or complete match with the expression will
  be removed. See \code{examples} for more details.
}
\examples{
folder <- system.file("extdata/cary/eem", package = "eemR")
eems <- eem_read(folder)

eem_extract(eems, c(1, 3)) ## Removes samples 1 and 3
eem_extract(eems, c(1, 3), remove = TRUE) ## extract samples 1 and 3

## Remove all samples containing "3" in their names.
eem_extract(eems, "3")

## Remove all samples containing either character "s" or character "2" in their names.
eem_extract(eems, c("s", "2"))

## Remove all samples containing "blank" or "nano"
eem_extract(eems, c("blank", "nano"))

## Remove all samples starting with "no"
eem_extract(eems, "^no")

}

