% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assign}
\alias{assign}
\alias{assign_trts}
\alias{assign_units}
\title{Assign treatments or units to units}
\usage{
assign_trts(
  .design,
  order = "random",
  seed = NULL,
  constrain = nesting_structure(.design),
  ...,
  .record = TRUE
)

assign_units(
  .design,
  order = "random",
  seed = NULL,
  constrain = nesting_structure(.design),
  ...,
  .record = TRUE
)
}
\arguments{
\item{.design}{An edibble design which should have units, treatments and allotment defined.}

\item{order}{A character vector signifying the apportion of treatments to units.
The value should be either "random", "systematic" or "systematic-random".
"random" allocates the treatment randomly to units based on specified allotment with restrictions
implied by unit structure.
"systematic" allocates the treatment in a systematic order to units.
"systematic-random" allocates the treatment in a systematic order to units but
where it is not possible to divide treatments equally (as the number of units are not divisible
by the number of levels of the treatment factor), then the extras are chosen randomly.}

\item{seed}{A scalar value used to set the seed so that the result is reproducible.}

\item{constrain}{The nesting structure for units.}

\item{...}{Arguments parsed into \code{order_trts} functions.}

\item{.record}{Whether to record the step.}
}
\value{
An edibble design.
}
\description{
This function assigns specific treatment or unit levels to actual units.
}
\examples{
# 10 subject, 2 vaccine treatments
design() \%>\%
  set_units(subject = 10) \%>\%
  set_trts(vaccine = 2) \%>\%
  allot_trts(vaccine ~ subject) \%>\%
  assign_trts() \%>\%
  serve_table()

# 20 subjects, 2 blocks, assign subjects to blocks
design() \%>\%
  set_units(subject = 20,
            block = 2) \%>\%
  allot_units(block ~ subject) \%>\%
  assign_units() \%>\%
  serve_table()
}
