% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/company_filings.R
\name{company_filings}
\alias{company_filings}
\title{SEC Company Filings}
\usage{
company_filings(x, ownership = FALSE, type = "", before = "",
  count = 40, page = 1)
}
\arguments{
\item{x}{either a stock ticker, CIK number, or XML document for a company page}

\item{ownership}{boolean for inclusion of company change filings}

\item{type}{Type of filing to fetch. NOTE: due to the way the SEC EDGAR system 
works, it is actually is a 'starts-with' search, so for instance specifying
'type = "10-K" will return "10-K/A" and "10-K405" filings as well. To ensure
you only get the type you want, best practice would be to filter the results.}

\item{before}{yyyymmdd format of latest filing to fetch}

\item{count}{Number of filings to fetch per page. Valid options are 10, 20, 40,
80, or 100. Other values will result in the closest count.}

\item{page}{Which page of results to return.}
}
\value{
A dataframe of company filings
}
\description{
SEC Company Filings
}
\examples{
company_filings("AAPL")
}
