% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilings.R
\name{getFilings}
\alias{getFilings}
\title{Retrieves EDGAR filings from SEC site.}
\usage{
getFilings(year, cik.no, form.type)
}
\arguments{
\item{year}{an integer specifies year for which EDGAR filings are to be downloaded.}

\item{cik.no}{an integer containing specific CIK number for which EDGAR filings are 
to be downloaded. cik.no = 'ALL' if required to download for all CIK's.}

\item{form.type}{character string containing specific Form type to be downloaded. 
form.type = 'ALL' if required to download all form-types.}
}
\value{
Function downloads EDGAR filings and returns download status data frame.
}
\description{
\code{getFilings} retrieves EDGAR filings for the specified CIK, form type,
and year mentioned in function parameters.
}
\details{
getFilings function takes year, form type, and CIK as an input.
Working directory should contain 'Master Index' 
directory which contains master Rda files for specific years downloaded using 
\link[edgar]{getMasterIndex} function. Function creates new directory 'Edgar filings'  
to store all downloaded filings. Please note, for all other functions in this 
package needs to locate the same working directory.
}
\examples{
\dontrun{

report <- getFilings(1994, 100030, 'ALL') 
## download all filings filed by the firm with CIK=100030 in the year 1994. 
## Generates download report in data frame.

report <- getFilings(2006, 1000180, '10-K')
## download '10-K' filings filed by the firm with CIK=1000180 in the year 2006. 
## Generates download report in data frame.
}

}

