% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_processing_time.R
\name{filter_processing_time}
\alias{filter_processing_time}
\alias{filter_processing_time.log}
\alias{filter_processing_time.grouped_log}
\title{Filter Processing Time}
\usage{
filter_processing_time(
  log,
  interval = NULL,
  percentage = NULL,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks"),
  eventlog = deprecated()
)

\method{filter_processing_time}{log}(
  log,
  interval = NULL,
  percentage = NULL,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks"),
  eventlog = deprecated()
)

\method{filter_processing_time}{grouped_log}(
  log,
  interval = NULL,
  percentage = NULL,
  reverse = FALSE,
  units = c("secs", "mins", "hours", "days", "weeks"),
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{interval, percentage}{Provide either \code{interval} or \code{percentage}.\cr
\code{interval} (\code{\link{numeric}} vector of length 2): A duration interval. Half open interval can be created using \code{\link{NA}}.\cr
\code{percentage} (\code{\link{numeric}}): A percentage to be used for relative filtering.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{units}{\code{\link{character}} (default \code{"secs"}): The time unit in which the processing times should be reported. Should be one of the following values:
\code{"secs"} (default), \code{"mins"}, \code{"hours"}, \code{"days"}, \code{"weeks"}. See also the \code{units} argument of \code{\link[=difftime]{difftime()}}.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Filters cases based on their \code{\link{processing_time}}.

This filter can be used by using an \code{interval} or by using a \code{percentage}.
The percentage will always start with the shortest cases first and stop
including cases when the specified percentile is reached. On the other hand, an absolute
interval can be defined instead to filter cases which have a processing time in this interval. The time units
in which this interval is defined can be supplied with the \code{units} argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_processing_time(log)}: Filters cases for a \code{\link[bupaR:log]{log}}.

\item \code{filter_processing_time(grouped_log)}: Filters cases for a \code{\link[bupaR:grouped_log]{grouped_log}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[=processing_time]{processing_time()}},\code{\link[=difftime]{difftime()}}

Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_flow_time}()},
\code{\link{filter_idle_time}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()},
\code{\link{filter_trim}()}
}
\concept{filters}
\concept{filters_case}
