% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_trim.R
\name{filter_trim}
\alias{filter_trim}
\alias{filter_trim.eventlog}
\alias{filter_trim.grouped_eventlog}
\alias{filter_trim.activitylog}
\alias{filter_trim.grouped_activitylog}
\title{Trim Cases}
\usage{
filter_trim(
  log,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_trim}{eventlog}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_trim}{grouped_eventlog}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_trim}{activitylog}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)

\method{filter_trim}{grouped_activitylog}(
  log,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{start_activities, end_activities}{\code{\link{character}} vector (default \code{\link{NULL}}): A vector of activity identifiers, or \code{\link{NULL}}.}

\item{reverse}{\code{\link{logical}} (default \code{FALSE}): Indicating whether the selection should be reversed.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\value{
When given an object of type \code{\link[bupaR]{log}}, it will return a filtered \code{\link[bupaR]{log}}.
When given an object of type \code{\link[bupaR]{grouped_log}}, the filter will be applied in a stratified way (i.e. each separately for each group).
The returned log will be grouped on the same variables as the original log.
}
\description{
Trim cases from the first event of a set of start activities to the last event of a set of end activities.

One can trim cases by removing one or more activity instances at the start and/or end of a case. Trimming is performed
until all cases have a start and/or end point belonging to a set of allowed activity labels. This filter requires a set
of allowed start activities and/or a set of allowed end activities. If one of them is not provided it will not trim the
cases at this edge. The selection can be reversed, which means that only the trimmed events at the start and end of cases
are retained. As such, this argument allows to cut intermediate parts out of traces.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_trim(eventlog)}: Filters activity instances for an \code{\link[bupaR]{eventlog}}.

\item \code{filter_trim(grouped_eventlog)}: Filters activity instances for a \code{\link[bupaR]{grouped_eventlog}}.

\item \code{filter_trim(activitylog)}: Filters activity instances for an \code{\link[bupaR]{activitylog}}.

\item \code{filter_trim(grouped_activitylog)}: Filters activity instances for a \code{\link[bupaR]{grouped_activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
Other filters: 
\code{\link{filter_activity_frequency}()},
\code{\link{filter_activity_instance}()},
\code{\link{filter_activity_presence}()},
\code{\link{filter_activity}()},
\code{\link{filter_case_condition}()},
\code{\link{filter_case}()},
\code{\link{filter_endpoints_condition}()},
\code{\link{filter_endpoints}()},
\code{\link{filter_infrequent_flows}()},
\code{\link{filter_lifecycle_presence}()},
\code{\link{filter_lifecycle}()},
\code{\link{filter_precedence_condition}()},
\code{\link{filter_precedence_resource}()},
\code{\link{filter_precedence}()},
\code{\link{filter_processing_time}()},
\code{\link{filter_resource_frequency}()},
\code{\link{filter_resource}()},
\code{\link{filter_throughput_time}()},
\code{\link{filter_time_period}()},
\code{\link{filter_trace_frequency}()},
\code{\link{filter_trace_length}()},
\code{\link{filter_trace}()},
\code{\link{filter_trim_lifecycle}()}
}
\concept{filters}
\concept{filters_event}
