% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_time_period.R
\name{filter_time_period}
\alias{filter_time_period}
\alias{filter_time_period.eventlog}
\alias{filter_time_period.grouped_eventlog}
\alias{ifilter_time_period}
\title{Filter: Time Period}
\usage{
filter_time_period(eventlog, interval, filter_method, force_trim, reverse, ...)

\method{filter_time_period}{eventlog}(
  eventlog,
  interval = NULL,
  filter_method = c("contained", "intersecting", "start", "complete", "trim"),
  force_trim = FALSE,
  reverse = FALSE,
  ...
)

\method{filter_time_period}{grouped_eventlog}(
  eventlog,
  interval = NULL,
  filter_method = c("contained", "intersecting", "start", "complete", "trim"),
  force_trim = FALSE,
  reverse = FALSE,
  ...
)

ifilter_time_period(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{interval}{A time interval. A vector of length 2 of type Date or POSIXct. Half-open intervals can be created with NA.}

\item{filter_method}{Can be \code{contained, start, complete, intersecting} or \code{trim}.}

\item{force_trim}{Logical, if true in combination with filter method trim activity instances on the edges of the interval are cut at the exact edge of the interval.}

\item{reverse}{Logical, indicating whether the selection should be reversed.}

\item{...}{Deprecated arguments.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Function to filter eventlog using a time period.
}
\details{
Event data can be filtered by supplying a time window to the method filter_time_period. There are 5 different filter methods.

\itemize{
\item \code{contained} keeps all the events related to cases contained in the time period.
\item \code{start} keeps all the events related to cases started in the time period.
\item \code{complete} keeps all the events related to cases complete in the time period.
\item \code{intersecting} keeps all the events related to cases in which at least one event started and/or ended in the time period.
\item \code{trim} keeps all the events which started and ended in the time frame.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
