% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_length.R
\name{trace_length}
\alias{trace_length}
\alias{trace_length.eventlog}
\alias{trace_length.grouped_eventlog}
\title{Metric: Trace length}
\usage{
trace_length(eventlog, level, append, ...)

\method{trace_length}{eventlog}(eventlog, level = c("log", "trace", "case"),
  append = F, ...)

\method{trace_length}{grouped_eventlog}(eventlog, level = c("log", "trace",
  "case"), append = F, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{...}{Deprecated arguments}
}
\description{
Analysis of trace lengths
}
\details{
This metric provides an overview of the number of activities that occur in each trace.
 In this metric, instances of an activity, as
 opposed to the actual activities, are calculated.

\itemize{

\item On the level of the log, the number of actual
 transactions in a trace are calculated and aggregated on the log level.

\item On the level of the cases, this metric calculates the number of activity instances in each case.

\item This metric shows the number of activity instances
 executed in each trace.
 #'
 }
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Trace length for  eventlog

\item \code{grouped_eventlog}: Trace length for grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
