% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.recombinator.crossover.R
\name{recCrossover}
\alias{recCrossover}
\title{One-point crossover recombinator.}
\usage{
recCrossover(inds)
}
\arguments{
\item{inds}{[\code{list}]\cr
Parents, i.e., list of exactly two numeric or binary vectors of equal length.}
}
\value{
[\code{list}]
}
\description{
The one-point crossover recombinator is defined for float and binary
representations. Given two real-valued/binary vectors of length n, the
selector samples a random position i between 1 and n-1. In the next step
it creates two children. The first part of the first child contains of the
subvector from position 1 to position i of the first parent, the second part
from position i+1 to n is taken from the second parent. The second child
is build analogously.
If the parents are list of real-valued/binary vectors, the procedure described
above is applied to each element of the list.
}
\seealso{
Other recombinators: \code{\link{recIntermediate}},
  \code{\link{recOX}}, \code{\link{recPMX}},
  \code{\link{recSBX}}, \code{\link{recUnifCrossover}}
}
