% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.parallelization.R
\name{ecr_parallelization}
\alias{ecr_parallelization}
\title{Parallelization in ecr}
\description{
In ecr it is possible to parallelize the fitness function evaluation
to make use, e.g., of multiple CP cores or nodes in a HPC cluster.
For maximal flexibility this is realized by means of the \pkg{parallelMap} package
(see the \href{https://github.com/berndbischl/parallelMap}{official
GitHub page} for instructions on how to set up parallelization).
The different levels of parallelization can be specified in the
\code{parallelStart*} function. At them moment only the level
\dQuote{ecr.evaluateFitness} is supported.

Keep in mind that parallelization comes along with some overhead. Thus activating
parallelization, e.g., for evaluation a fitness function which is evaluated
lightning-fast, may result in higher computation time. However, if the function
evaluations are computationally more expensive, parallelization leads to
significant running time benefits.
}
