% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecospace.R
\docType{package}
\name{ecospace-package}
\alias{ecospace}
\alias{ecospace-package}
\title{ecospace: Simulating Community Assembly and Ecological Diversification Using
Ecospace Frameworks}
\description{
ecospace is an R package that implements stochastic simulations of community
assembly (ecological diversification) using customizable ecospace frameworks
(functional trait spaces). Simulations model the 'neutral', 'redundancy',
'partitioning', and 'expansion' models of Bush and Novack-Gottshall (2012)
and Novack-Gottshall (2016a,b). It provides a wrapper to calculate common
ecological disparity and functional ecology statistical dynamics as a
function of species richness. Functions are written so they will work in a
parallel-computing environment.
}
\details{
The package also contains a sample data set, functional traits for Late
Ordovician (Type Cincinnatian) fossil species from the Kope and Waynesville
formations, from Novack-Gottshall (2016b).
}
\examples{
# Get package version, citation, updates, and vignette
packageVersion("ecospace")
citation("ecospace")
news(package="ecospace")
vignette("ecospace")

# Create an ecospace framework (functional-trait space) with 15 characters
#    (functional traits) of mixed types
nchar <- 15
ecospace <- create_ecospace(nchar=nchar, char.state=rep(3, nchar),
  char.type=rep(c("factor", "ord.fac", "ord.num"), nchar / 3))

# Use to assemble a stochastic "neutral" sample of 20 species (from
#    initial seeding by 5 species)
x <- neutral(Sseed=5, Smax=20, ecospace=ecospace)
head(x, 10)

# Calculate ecological disparity (functional diversity) dynamics as a
#    function of species richness
# Statistic 'V' [total variance] not calculated because there are factors
#    in the sample
metrics <- calc_metrics(samples=x, Smax=20, Model="Neutral", Param="NA")
metrics

# Plot statistical dynamics as function of species richness
op <- par()
par(mfrow=c(2,4), mar=c(4, 4, 1, .3))
attach(metrics)
plot(S, H, type="l", cex=.5)
plot(S, D, type="l", cex=.5)
plot(S, M, type="l", cex=.5)
plot(S, V, type="l", cex=.5)
plot(S, FRic, type="l", cex=.5)
plot(S, FEve, type="l", cex=.5)
plot(S, FDiv, type="l", cex=.5)
plot(S, FDis, type="l", cex=.5)

par(op)

}
\author{
Phil Novack-Gottshall \email{pnovack-gottshall@ben.edu}
}
\references{
Bush, A. and P.M. Novack-Gottshall. 2012. Modelling the
  ecological-functional diversification of marine Metazoa on geological time
  scales. \emph{Biology Letters} 8: 151-155.

Novack-Gottshall, P.M. 2016a. General models of ecological
  diversification. I. Conceptual synthesis. \emph{Paleobiology} 42: 185-208.

Novack-Gottshall, P.M. 2016b. General models of ecological
  diversification. II. Simulations and empirical applications.
  \emph{Paleobiology} 42: 209-239.
}
\seealso{
The 'calc_metrics' function relies extensively on the functional
diversity package \code{\link[FD]{FD}}, and hence lists this package as a
depends, so it is loaded simultaneously.
}

