% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div.r
\name{generalized_unifrac}
\alias{generalized_unifrac}
\title{Generalized UniFrac}
\usage{
generalized_unifrac(
  counts,
  tree = NULL,
  alpha = 0.5,
  pairs = NULL,
  cpus = n_cpus()
)
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{alpha}{How much weight to give to relative abundances; a value
between 0 and 1, inclusive. Setting \code{alpha=1} is equivalent to
\code{weighted_normalized_unifrac()}.}

\item{pairs}{Which combinations of samples should distances be
calculated for? The default value (\code{NULL}) calculates all-vs-all.
Provide a numeric or logical vector specifying positions in the
distance matrix to calculate. See examples.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A \code{dist} object.
}
\description{
Generalized UniFrac beta diversity metric.
}
\section{Calculation}{


Given \eqn{n} branches with lengths \eqn{L}, a pair of samples'
abundances (\eqn{A} and \eqn{B}) on each of those branches, and
abundance weighting \eqn{0 \le \alpha \le 1}:

\deqn{D = \displaystyle \frac{\sum_{i = 1}^{n} L_i(\frac{A_i}{A_T} + \frac{B_i}{B_T})^{\alpha}|\displaystyle \frac{\frac{A_i}{A_T} - \frac{B_i}{B_T}}{\frac{A_i}{A_T} + \frac{B_i}{B_T}} |}{\sum_{i = 1}^{n} L_i(\frac{A_i}{A_T} + \frac{B_i}{B_T})^{\alpha}}}

See \code{vignette('unifrac')} for details and a worked example.
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Generalized UniFrac distance matrix
    generalized_unifrac(ex_counts, tree = ex_tree)
    
    # Only calculate distances for A vs all.
    generalized_unifrac(ex_counts, tree = ex_tree, pairs = 1:3)
    
}
\references{
Chen J, Bittinger K, Charlson ES, Hoffmann C, Lewis J, Wu GD, Collman RG, Bushman FD, Li H 2012.
Associating microbiome composition with environmental covariates using generalized UniFrac distances.
Bioinformatics, 28(16).
\doi{10.1093/bioinformatics/bts342}
}
\seealso{
Other beta_diversity: 
\code{\link{bray_curtis}()},
\code{\link{canberra}()},
\code{\link{euclidean}()},
\code{\link{gower}()},
\code{\link{jaccard}()},
\code{\link{kulczynski}()},
\code{\link{manhattan}()},
\code{\link{unweighted_unifrac}()},
\code{\link{variance_adjusted_unifrac}()},
\code{\link{weighted_normalized_unifrac}()},
\code{\link{weighted_unifrac}()}
}
\concept{beta_diversity}
