% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_taxon.R
\name{create_taxon}
\alias{create_taxon}
\title{Create the taxon table}
\usage{
create_taxon(
  L0_flat,
  taxon_id,
  taxon_rank = NULL,
  taxon_name,
  authority_system = NULL,
  authority_taxon_id = NULL
)
}
\arguments{
\item{L0_flat}{(tbl_df, tbl, data.frame) The fully joined source L0 dataset, in "flat" format (see details).}

\item{taxon_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique organism at the observation level.}

\item{taxon_rank}{(character) An optional column in \code{L0_flat} containing the taxonomic rank of the organism in \code{taxon_name}.}

\item{taxon_name}{(character) Column in \code{L0_flat} containing the taxonomic name of the organism.}

\item{authority_system}{(character) An optional column in \code{L0_flat} containing the name of the authority system \code{authority_taxon_id} is from (e.g. "ITIS").}

\item{authority_taxon_id}{(character) An optional column in \code{L0_flat} containing the identifier corresponding to \code{taxon_name} in the \code{authority_system}.}
}
\value{
(tbl_df, tbl, data.frame) The taxon table.
}
\description{
Create the taxon table
}
\details{
This function collects specified columns from \code{L0_flat} and returns distinct rows.

Taxa listed in the taxon table, and resolved to one of the supported authority systems (i.e. \href{https://www.itis.gov/}{ITIS}, \href{http://www.marinespecies.org/}{WORMS}, or \href{https://gbif.org}{GBIF}), will have their full taxonomic hierarchy expanded, including any common names for each level.

"flat" format refers to the fully joined source L0 dataset in "wide" form with the exception of the core observation variables, which are in "long" form (i.e. using the variable_name, value, unit columns of the observation table). This "flat" format is the "widest" an L1 ecocomDP dataset can be consistently spread due to the frequent occurrence of L0 source datasets with > 1 core observation variable.
}
\examples{
flat <- ants_L0_flat

taxon <- create_taxon(
  L0_flat = flat, 
  taxon_id = "taxon_id", 
  taxon_rank = "taxon_rank", 
  taxon_name = "taxon_name", 
  authority_system = "authority_system", 
  authority_taxon_id = "authority_taxon_id")

taxon

}
