% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_funnel}
\alias{e_funnel}
\alias{e_funnel_}
\title{Funnel}
\usage{
e_funnel(e, values, labels, name = NULL, legend = TRUE, rm_x = TRUE,
  rm_y = TRUE, ...)

e_funnel_(e, values, labels, name = NULL, legend = TRUE, rm_x = TRUE,
  rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{values, labels}{Values and labels of funnel.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass to \code{bar} or \code{line} char types.}
}
\description{
Add a funnel.
}
\details{
No \code{bind} argument here, with a funnel \code{bind} = \code{labels}.
}
\examples{
funnel <- data.frame(
  stage = c("View", "Click", "Purchase"), 
  value = c(80, 30, 20)
)

funnel \%>\% 
  e_charts() \%>\% 
  e_funnel(value, stage)

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-funnel}{Additional arguments}
}
