% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-class.R
\docType{class}
\name{lamp-class}
\alias{lamp-class}
\title{An S4 class to represent the lambda process}
\description{
The \code{lamp} class serves as an object-oriented interface for the lambda process.
The main purpose of the class is to store all the parameters required for simulation.
}
\section{Slots}{

\describe{
\item{\code{call}}{the match.call slot.}

\item{\code{lambda}}{numeric, lambda index of lambda process, which is 2/alpha.}

\item{\code{alpha}}{numeric, stable alpha. This is derived from lambda for convenience reason.}

\item{\code{beta}}{numeric, stable beta.}

\item{\code{pm}}{numeric, parameterization, default to 1.}

\item{\code{rnd.walk}}{numeric, Random walk method. Default is 1.}

\item{\code{sd}}{numeric, standard deviation adjustment. No adjustment if NaN.}

\item{\code{sd.method}}{numeric, methodology of sd adjustment. 0 means in scale parameter, 1 means in Levy sums.}

\item{\code{T.inf}}{numeric, the infinite bound to cut off the Levy sums.}

\item{\code{rnd.n}}{numeric, the length of one rnd call.}

\item{\code{N.lower}}{numeric, the lower bound of N to truncate the boundary effect. Default is 0.}

\item{\code{N.upper}}{numeric, the upper bound of N to limit the outliers. Default is 1000.}

\item{\code{use.mpfr}}{logical, use Mpfr for high precision sums.}

\item{\code{file}}{character, file path to save the object and simulation result.}

\item{\code{tau}}{numeric, storage for the stable random variables.}

\item{\code{tau_i}}{numeric, for internal use, length or index of tau.}

\item{\code{Z_i}}{numeric, length of Z.}

\item{\code{Z}}{numeric, simulation result of the lambda process, Z.}

\item{\code{B}}{numeric, simulation result of the binomial process, B.}

\item{\code{N}}{numeric, simulation result of the count process, N.}

\item{\code{tm}}{POSIXct, timestamp of simulation.}
}}

\author{
Stephen H. Lihn
}
\keyword{lamp}
