% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{ebirdst_download_data_coverage}
\alias{ebirdst_download_data_coverage}
\title{Download eBird Status and Trends Data Coverage Products}
\usage{
ebirdst_download_data_coverage(
  path = ebirdst_data_dir(),
  pattern = NULL,
  dry_run = FALSE,
  force = FALSE,
  show_progress = TRUE
)
}
\arguments{
\item{path}{character; directory to download the data to. All downloaded
files will be placed in a sub-directory of this directory named for the
data version year, e.g. "2020" for the 2020 Status Data Products. Each
species' data package will then appear in a directory named with the eBird
species code. Defaults to a persistent data directory, which can be found
by calling \code{ebirdst_data_dir()}.}

\item{pattern}{character; regular expression pattern to supply to
\link[stringr:str_detect]{str_detect()} to filter files to download. This
filter will be applied in addition to any of the \code{download_} arguments.
Note that some files are mandatory and will always be downloaded.}

\item{dry_run}{logical; whether to do a dry run, just listing files that will
be downloaded. This can be useful when testing the use of \code{pattern} to
filter the files to download.}

\item{force}{logical; if the data have already been downloaded, should a
fresh copy be downloaded anyway.}

\item{show_progress}{logical; whether to print download progress information.}
}
\value{
Path to the folder containing the downloaded data coverage products.
}
\description{
In addition to the species-specific data products, the eBird Status data
products include two products providing estimates of weekly data coverage at
3 km spatial resolution: site selection probability and spatial coverage.
This function downloads these data products in raster GeoTIFF format.
}
\examples{
\dontrun{
# download all data coverage products
ebirdst_download_data_coverage()

# download just the spatial coverage products
ebirdst_download_data_coverage(pattern = "spatial-coverage")

# download a single week of data coverage products
ebirdst_download_data_coverage(pattern = "01-04")

# download all weeks in april
ebirdst_download_data_coverage(pattern = "04-")
}
}
