% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-mapping.R
\name{calc_bins}
\alias{calc_bins}
\title{Calculates relative abundance bins (breaks) based for mapping}
\usage{
calc_bins(abundance, count)
}
\arguments{
\item{abundance}{\code{Raster} object; eBird Status and Trends relative abundance
data cube, or a subset of the data cube.}

\item{count}{\code{Raster} object; eBird Status and Trends count data cube, or a
subset of the data cube.}
}
\value{
A numeric vector defining the breaks of the relative abundance bins.
In addition, the \code{labels} attribute of this vector provides the 5th, 50th,
and 95th quantile of abundance, which can be used to label the bottom,
middle, and top of a legend.
}
\description{
Mapping species abundance across the full-annual cycle presents a challenge,
in that patterns of concentration and dispersion in abundance change
throughout the year, making it difficult to define color bins that suit all
seasons and accurately reflect the detail of abundance predictions. To
address this, when mapping the relative abundance data, we recommend using
quantile bins based on the underlying count distribution, adjusted
according to the relative abundance distribution. To access pre-calculated
bins for the full annual cycle use \code{\link[=load_fac_map_parameters]{load_fac_map_parameters()}}.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# abundance data
abd <- load_raster(path, "abundance")
# count data
cnt <- load_raster(path, "count")

# calculate bins for a single week for this example
bins <- calc_bins(abd, cnt)
}
}
