% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_test_data}
\alias{load_test_data}
\title{Test data loader}
\usage{
load_test_data(path, return_sf = FALSE)
}
\arguments{
\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
data.frame containing test data, including checklist locations,
observed counts, and predictor variables.
}
\description{
Internal function used by \code{\link[=compute_ppms]{compute_ppms()}} to get the full test data set for
calculating predictive performance metrics. This file contains the observed
counts and all predictor variables used for modeling for each checklist in
the test dataset.
}
\examples{
\dontrun{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# test data
test_data <- ebirdst:::load_test_data(sp_path)
dplyr::glimpse(test_data)
}
}
\keyword{internal}
