% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_convertLabel.R
\name{import_convertLabel}
\alias{import_convertLabel}
\title{Import an object imported via \code{convertLabel}}
\usage{
import_convertLabel(df, checkVarNames = TRUE)
}
\arguments{
\item{df}{A \code{data.frame}.}

\item{checkVarNames}{Should variable names be checked for violations of \code{SQLite} and \code{R} naming rules?}
}
\value{
Returns a list with the actual data \code{dat} and a data frame with all meta information in long format \code{labels}.
}
\description{
Function to import a \code{data.frame} object created by \code{convertLabel} for use in \code{eatGADS}. If possible, importing data via \code{\link{import_spss}} should always be preferred.
}
\details{
\code{convertLabel} from \code{R} package \code{eatAnalysis} converts an object imported via \code{read.spss} (from the \code{foreign} package) to a \code{data.frame} with factors and variable labels stored in variable attributes.
}
