% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareGADS.R
\name{compareGADS}
\alias{compareGADS}
\title{Compare two GADS.}
\usage{
compareGADS(
  GADSdat_old,
  GADSdat_new,
  varNames,
  output = c("list", "data.frame", "aggregated")
)
}
\arguments{
\item{GADSdat_old}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{GADSdat_new}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varNames}{Character string of variable names to be compared.}

\item{output}{How should the output be structured?}
}
\value{
Returns either a list with \code{"all equal"} and \code{data.frames} or a single \code{data.frame}.
}
\description{
Compare multiple variables of two \code{GADSdat} or \code{all_GADSdat} objects.
}
\details{
Returns \code{"all equal"} if the variable is identical across the objects or a \code{data.frame}
containing a frequency table with the values which have been changed. Especially useful for checks
after recoding.
}
\examples{
# Recode a GADS
pisa2 <- recodeGADS(pisa, varName = "schtype",
                        oldValues = 3, newValues = 9)
pisa2 <- recodeGADS(pisa2, varName = "language",
                        oldValues = 1, newValues = 15)

# Compare
compareGADS(pisa, pisa2,
            varNames = c("ganztag", "schtype", "language"), output = "list")
compareGADS(pisa, pisa2,
            varNames = c("ganztag", "schtype", "language"), output = "data.frame")
compareGADS(pisa, pisa2,
             varNames = c("ganztag", "schtype", "language"), output = "aggregated")

}
