% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equalGADS.R
\name{equalGADS}
\alias{equalGADS}
\title{Test if Two \code{GADSdat} Objects are (Nearly) Equal}
\usage{
equalGADS(
  target,
  current,
  metaExceptions = c("display_width", "labeled"),
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{target}{A \code{GADSdat} object.}

\item{current}{A \code{GADSdat} object.}

\item{metaExceptions}{Should certain meta data columns be excluded from the comparison?}

\item{tolerance}{A numeric value greater than or equal to \code{0}. Differences smaller than \code{tolerance} are not reported.
The default value is close to \code{1.5e-8}.}
}
\value{
Returns a list.
}
\description{
Run tests to check whether two \code{GADSdat} objects are (nearly) equal. Variable names, number of rows in the data,
meta data and data differences are checked and reported as a list output.
}
