% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemsPerFormConstraint.R
\name{itemsPerFormConstraint}
\alias{itemsPerFormConstraint}
\title{Create number of items per test form constraints.}
\usage{
itemsPerFormConstraint(
  nForms,
  nItems,
  operator = c("<=", "=", ">="),
  targetValue
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{operator}{a character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{The target value to be used in the constraints. That is,
the number of items per form.}
}
\value{
A sparse matrix.
}
\description{
Creates constraints related to the number of items in each test form.
}
\details{
The number of items per test form is constrained to be either
(a) smaller or equal than (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater or equal than
(\code{operator = ">="}) the chosen \code{value}.
}
\examples{
## Constrain the test forms to have exactly five items
itemsPerFormConstraint(3, 20, operator = "=", targetValue = 5)

}
