% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyCEAT.R
\name{efficiencyCEAT}
\alias{efficiencyCEAT}
\title{Efficiency Scores computed through a Convexified Efficiency Analysis Trees model.}
\usage{
efficiencyCEAT(
  data,
  x,
  y,
  object,
  scores_model,
  digits = 3,
  DEA = TRUE,
  print.table = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the variables in the model.}

\item{x}{Column input indexes in \code{data}.}

\item{y}{Column output indexes in \code{data}.}

\item{object}{An \code{EAT} object.}

\item{scores_model}{Mathematical programming model to calculate scores. 
\itemize{
\item{\code{BCC.OUT} BCC model. Output-oriented. Efficiency level at 1.}
\item{\code{BCC.INP}  BCC model. Input-oriented. Efficiency level at 1.}
\item{\code{DDF}     Directional Distance Function. Efficiency level at 0.}
\item{\code{RSL.OUT} Russell model. Output-oriented. Efficiency level at 1.}
\item{\code{RSL.INP}  Russell model. Input-oriented. Efficiency level at 1.}
\item{\code{WAM.MIP} Weighted Additive Model. Measure of Inefficiency Proportions. Efficiency level at 0.}
\item{\code{WAM.RAM} Weighted Additive Model. Range Adjusted Measure of Inefficiency. Efficiency level at 0.}
}}

\item{digits}{Decimal units for scores.}

\item{DEA}{\code{logical}. If \code{TRUE}, the DEA scores are also calculated with the programming model selected in \code{scores_model}.}

\item{print.table}{\code{logical}. If \code{TRUE}, a summary descriptive table of the efficiency scores is displayed.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
A \code{data.frame} with the efficiency scores computed through a Convexified Efficiency Analysis Trees model. Optionally, a summary descriptive table of the efficiency scores can be displayed.
}
\description{
This function computes the efficiency scores for each DMU through a Convexified Efficiency Analysis Trees model.
}
\examples{

\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

efficiencyCEAT(data = simulated, x = c(1, 2), y = c(3, 4), object = EAT_model, 
              scores_model = "BCC.OUT", digits = 2, DEA = TRUE, print.table = TRUE,
              na.rm = TRUE)
}

}
