% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userPredictions.R
\name{predictRFEAT}
\alias{predictRFEAT}
\title{Model prediction for Random Forest + Efficiency Analysis Trees model.}
\usage{
predictRFEAT(object, newdata, x)
}
\arguments{
\item{object}{A RFEAT object.}

\item{newdata}{Dataframe. Set of input variables to predict on.}

\item{x}{Inputs index}
}
\value{
Data frame with the original data and the predicted values.
}
\description{
This function predicts the expected output by a RFEAT object.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
RFEAT_model <- RFEAT(data = simulated, x = c(1,2), y = c(3, 4))

predictRFEAT(object = RFEAT_model, newdata = simulated, x = c(1,2))
}

}
