% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Artist.R
\name{Artist}
\alias{Artist}
\title{Visualization Artist for Custom Plots}
\value{
The \code{R6} class \link{Artist}.
}
\description{
The \code{Artist} class provides a collection of methods to create various types of plots using \code{ggplot2}.
It includes methods for generating dumbbell plots, bubble plots, divergence bar charts, lollipop plots,
contour plots, scatter plots with ellipses, donut plots, and pie charts. Each method is designed
to map data to specific aesthetics and apply additional customizations.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Artist-dumbbbell}{\code{Artist$dumbbbell()}}
\item \href{#method-Artist-bubble}{\code{Artist$bubble()}}
\item \href{#method-Artist-barchart_divergence}{\code{Artist$barchart_divergence()}}
\item \href{#method-Artist-lollipop}{\code{Artist$lollipop()}}
\item \href{#method-Artist-contour}{\code{Artist$contour()}}
\item \href{#method-Artist-scatter_ellipses}{\code{Artist$scatter_ellipses()}}
\item \href{#method-Artist-donut}{\code{Artist$donut()}}
\item \href{#method-Artist-pie}{\code{Artist$pie()}}
\item \href{#method-Artist-clone}{\code{Artist$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-dumbbbell"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-dumbbbell}{}}}
\subsection{Method \code{dumbbbell()}}{
Create a dumbbell plot

This method generates a dumbbell plot using the provided data, mapping the specified columns
to the x-axis, y-axis, and color aesthetic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$dumbbbell(data, x, y, col, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{col}}{The column in \code{data} to map to the color aesthetic.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the dumbbell plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-bubble"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-bubble}{}}}
\subsection{Method \code{bubble()}}{
Create a bubble plot

This method generates a bubble plot where points are mapped to the x and y axes, with their
size and color representing additional variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$bubble(data, x, y, size, col, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{size}}{The column in \code{data} to map to the size of the points.}

\item{\code{col}}{The column in \code{data} to map to the color of the points.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the bubble plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-barchart_divergence"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-barchart_divergence}{}}}
\subsection{Method \code{barchart_divergence()}}{
Create a divergence bar chart

This method generates a divergence bar chart where bars are colored based on their
positive or negative value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$barchart_divergence(data, group, y, fill, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{group}}{The column in \code{data} representing the grouping variable.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{fill}}{The column in \code{data} to map to the fill color of the bars.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the divergence bar chart.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-lollipop"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-lollipop}{}}}
\subsection{Method \code{lollipop()}}{
Create a lollipop plot

This method generates a lollipop plot, where points are connected to a baseline by vertical
segments, with customizable colors and labels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$lollipop(data, x, y, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the lollipop plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-contour"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-contour}{}}}
\subsection{Method \code{contour()}}{
Create a contour plot

This method generates a contour plot that includes filled and outlined density contours,
with data points overlaid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$contour(data, x, y, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the contour plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-scatter_ellipses"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-scatter_ellipses}{}}}
\subsection{Method \code{scatter_ellipses()}}{
Create a scatter plot with ellipses

This method generates a scatter plot where data points are colored by group, with ellipses
representing the confidence intervals for each group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$scatter_ellipses(data, x, y, col, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{col}}{The column in \code{data} to map to the color aesthetic.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the scatter plot with ellipses.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-donut"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-donut}{}}}
\subsection{Method \code{donut()}}{
Create a donut plot

This method generates a donut plot, which is a variation of a pie chart with a hole in the center.
The sections of the donut represent the proportion of categories in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$donut(data, x, y, fill, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{x}}{The column in \code{data} to map to the x-axis.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{fill}}{The column in \code{data} to map to the fill color of the sections.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the donut plot.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-pie"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-pie}{}}}
\subsection{Method \code{pie()}}{
Create a pie chart

This method generates a pie chart where sections represent the proportion of categories in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$pie(data, y, fill, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A data frame containing the data to be plotted.}

\item{\code{y}}{The column in \code{data} to map to the y-axis.}

\item{\code{fill}}{The column in \code{data} to map to the fill color of the sections.}

\item{\code{...}}{Additional aesthetic mappings or other arguments passed to \code{ggplot}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object representing the pie chart.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Artist-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Artist-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Artist$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
